# Vespucci 14.1 Highlights

2020-03-15

This is a minor release with many small improvements. 14.1 is the last release that will support devices with Android versions older than 4.0 / API 14, if you have been using the "current" releases from F-Droid or the google play store nothing will change for you, if you have been using the "legacy" build, you will either need a new device or try to upgrade the Android version on your existing one.

### Drag "ring" around selected nodes

To make selection status clearer selected nodes now have a small ring around them indicating the area that can be used for dragging. This is the same principle as the "large drag area" that has been available for many years. 

### Add and check website tags with dialog

This replaces the prior pre-filled in _http://_ prefix in the text fields with a dialog that allows checking the domain on the fly, and adding the correct protocol automatically. This requires network connectivity to work.

### Preset matching improvements

We now support a *min_match* preset item attribute that can be used to set how many fixed value tags need to match before the preset is considered for further scoring. Prior behaviour, and the default, is that all fixed tags need to match. This allows for better matching and handling of objects that currently have widespread use of two independent top level tags, for example _amenity=doctors_ together with _healthcare=doctor_.

### Data rendering

Simple closed-way based areas can now be rendered separately from a non-closed way with the same tags. Some initial incomplete documentation on the styling system has been added to the tutorials section. 

### Improved external location sources support

This release fixes a regression that stopped external location sources (for example Rtklib) working for devices with Android N and later. Additionally stability of the system when using such sources has been improved, including better messaging.

### Support for filtering background / overlay imagery by category

Imagery layers now have a _category_ attribute that can be used to filter the layers in the selection dialogs. Currently the UI just offers _All_ and _Aerial imagery_ (that is current/recent aerial and satellite imagery), but if there is interest this can be refined further.

### Use location to determine appropriate language specific tags

This replaces the facility that added language specific tags based on the device language. _Add language tags_ will now add language tags based on the location and the corresponding configuration from  [https://github.com/simonpoole/geocontext/](https://github.com/simonpoole/geocontext/).

Example: adding a restaurant in Switzerland and then selecting _Add language tags_ in the property editor will add _name:de_, _name:fr_, _name:it_, _name:rm_ and _name:gsw_ tags.

### Object search

Vespucci now supports most of JOSMs object search "language". This can be used from the main menu and from the element selection modes. As the JOSM documentation on the feature is near non-existent it is completely possible that there are subtle behaviour differences. Currently found objects will always replace the selection of any previously selected objects and the screen will be automatically be zoomed to the bounding box of the found elements.

When editing elements in the property editor, relation roles will be filtered by the member_expression attribute value if present, this uses the same language.

### Indication of stale location

The location indicator will change to black (styleable) after a user configurable time (default 60 seconds) to indicate that the position is stale. This function only works for android 4.2 (API 17) and later.

### Private api keys support

Open source projects are always in a bit of conundrum with respect to api keys, on the one hand by definition these should be private, on the other hand when core functionality depends on them we can't simply not store them with the code if they are needed at build time for 3rd parties. 

For example so that users of the F-Droid build can actually log in securely with OAuth without having to store their login credentials on the device, we need to include the OAuth client keys as F-Droid has no provision for keeping keys private (this does create the vulnerability that an app could masquerade as Vespucci, but the impacts of that are very limited).

For keys that are used solely to access services that are not critical the situation is different. The main use of these today is to access imagery sources, starting with this release, private imagery keys are provided at build time and are no longer stored in the source code repository with the exception of the Bing key that will remain for now. As a consequence the Thunderforest maps and the MAXAR aerial imagery will no longer be available in the F-Droid build.

In the current implementation there is no way to set your own keys or otherwise manage them, for imagery keys this is not an issue as you can simply add a custom imagery entry that directly contains the key. In the future we might provide such a management facility.

From a formal security point of view all of this is naturally a bit of snake oil as for example imagery apikeys that are used in urls are trivial to snoop, but at least that implies putting some effort in to finding the keys over simply scraping github repositories.

### Help viewer

The help viewer can now be accessed without starting the full app first, this has the added advantage that the viewer can be used in split window mode on devices that support it, or at least be used without restarting the activity. 

## Miscellaneous

* Improvements custom imagery, OAM support and imagery layer info
* Add mechanism to filter out bad OAM entries
* Display a toast if the user needs to restart the app after a preference change
* Add preference to control phone number formatting
* Support adding empty value values to MRU when use_last_as_default is set
* Add facility to determine if there is device specific brokeness (fullscreen mode support)
* Support autoapply preset attribute to avoid applying preset automatically when it will break things.
* Use Note specific icons
* Add support for tunnel and bridge specific rendering for some roads
* Changing the accessibility font size setting will scale the preset "buttons" too.
* Untagged objects now have a different header in the property editor.
* Files that were downloaded with Firefox mobile couldn't be accessed, this has been resolved.
* Re-factored undo and OSC code.

# Upgrading from previous versions

* The format of the saved editing state (not of the saved data) has changed, you should still upload any changes before updating.

# Known problems

* When editing multi-valued text fields, specifically _destination:lanes_, an empty final value will result in the trailing separator to be removed, see [issue 1072](https://github.com/MarcusWolschon/osmeditor4android/issues/1072) and [issue 1073](https://github.com/MarcusWolschon/osmeditor4android/issues/1073).
* The documentation is out of date.
* For known problems with this build please see [our issue tracker](https://github.com/MarcusWolschon/osmeditor4android/issues)

